import LicenseSpring

import SwiftUI
import UniformTypeIdentifiers

struct InitialFloatingClientView: View {
    @State private var user = ""
    
    let manager: FloatingClient!
    @Binding var showConfiguration: Bool
    
    @EnvironmentObject private var viewUpdater: ViewUpdaterHack
    
    var body: some View {
        InitialViewContainer(manager: nil, showConfiguration: $showConfiguration, showProductDetails: false) {
            GroupBox(label: Text("Online Activation")) {
                HStack(alignment: .top) {
                    Text("").frame(maxWidth: .infinity)
                    VStack {
                        Text("User-based product")
                        TextField("User", text: $user)
                        MinWidthButton("Activate") {
                            performAction(name: "Activate License", successAlert: false) {
                                _ = try manager.register(userID: user)
                            }
                        }
                        .disabled(user.isEmpty)
                    }
                    Text("").frame(maxWidth: .infinity)
                }
            }
        }
    }
}

struct InitialFloatingClientView_Previews: PreviewProvider {
    static var previews: some View {
        InitialFloatingClientView(manager: nil, showConfiguration: .constant(false))
    }
}
